#define BitDown 5
#define BitUp 3
//---------------------------------
#include <stdio.h>
//-------Globals&Externs-----------
int glb_reg;
#define REG_ADDR  &glb_reg  

//---------------------------------
int main()
{	
	
	//in order to access address we must declare a pointer //to it
	int* preg = (int*)REG_ADDR;
	
	//setting some initial value in address: REG_ADDR
	*preg = 0x1a2b3ca6;
	printf("initial Reg: %#x\n",*preg);

	//set to zero the bit of index BitDown
	*preg &= ~(1<<BitDown); 
	
	//set to one  the bit of index BitUp
	*preg |= (1<<BitUp);  

	printf("Final Reg:   %#x\n",*preg);
	
	
	
	//----another implementation:-------------------
	//Accessing and setting specific bits
	//Read modify write, but in a more generic approach 

	//setting bits 3 and 5 inside a 32bit register to '0' and //'1' respectively.
	int  myReg = 0x1a2b3ca6; //0x1a2b3c|0100|1101|

	int newVal = 0x00008;  //00...|0000|1000|
	int mask = 0x0028;     //00...|0010|1000|

	printf("\n\n\nInitial myReg value: %#x\n",myReg );
		
	mask  = ~mask;    //11...1|1101|0111| creating the required mask
	myReg &=mask;    //**old**|**0*|0***| zerroing the bits I"m about to modify

	myReg |= newVal; //final myReg = 0x1a2b3c65 

	printf("Final myReg value: %#x\n",myReg );	

	return 0;
}
